/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.internal.vectorization;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.nio.ByteOrder;
import jdk.incubator.vector.IntVector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;
import org.apache.lucene.ars_nouveau.internal.vectorization.PanamaVectorConstants;
import org.apache.lucene.ars_nouveau.internal.vectorization.PostingDecodingUtil;
import org.apache.lucene.ars_nouveau.store.IndexInput;

final class MemorySegmentPostingDecodingUtil
extends PostingDecodingUtil {
    private static final VectorSpecies<Integer> INT_SPECIES = PanamaVectorConstants.PRERERRED_INT_SPECIES;
    private final MemorySegment memorySegment;

    MemorySegmentPostingDecodingUtil(IndexInput in, MemorySegment memorySegment) {
        super(in);
        this.memorySegment = memorySegment;
    }

    private static void shift(IntVector vector, int bShift, int dec, int maxIter, int bMask, int[] b, int count, int i) {
        for (int j = 0; j <= maxIter; ++j) {
            vector.lanewise(VectorOperators.LSHR, bShift - j * dec).lanewise((VectorOperators.Binary)VectorOperators.AND, bMask).intoArray(b, count * j + i);
        }
    }

    @Override
    public void splitInts(int count, int[] b, int bShift, int dec, int bMask, int[] c, int cIndex, int cMask) throws IOException {
        IntVector vector;
        if (count < INT_SPECIES.length()) {
            super.splitInts(count, b, bShift, dec, bMask, c, cIndex, cMask);
            return;
        }
        int maxIter = (bShift - 1) / dec;
        long offset = this.in.getFilePointer();
        long endOffset = offset + (long)(count * 4);
        int loopBound = INT_SPECIES.loopBound(count - 1);
        int i = 0;
        while (i < loopBound) {
            vector = IntVector.fromMemorySegment(INT_SPECIES, (MemorySegment)this.memorySegment, (long)offset, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            MemorySegmentPostingDecodingUtil.shift(vector, bShift, dec, maxIter, bMask, b, count, i);
            vector.lanewise((VectorOperators.Binary)VectorOperators.AND, cMask).intoArray(c, cIndex + i);
            i += INT_SPECIES.length();
            offset += (long)(INT_SPECIES.length() * 4);
        }
        i = count - INT_SPECIES.length();
        offset = endOffset - (long)(INT_SPECIES.length() * 4);
        vector = IntVector.fromMemorySegment(INT_SPECIES, (MemorySegment)this.memorySegment, (long)offset, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        MemorySegmentPostingDecodingUtil.shift(vector, bShift, dec, maxIter, bMask, b, count, i);
        vector.lanewise((VectorOperators.Binary)VectorOperators.AND, cMask).intoArray(c, cIndex + i);
        this.in.seek(endOffset);
    }
}

